<?php
require_once 'db_pdo.php';
header('Content-Type: application/json; charset=utf-8');

$seccion_id  = isset($_GET['seccion_id'])  ? (int)$_GET['seccion_id']  : 0;
$cargo_id    = isset($_GET['cargo_id'])    ? (int)$_GET['cargo_id']    : 0;
$eleccion_id = isset($_GET['eleccion_id']) ? (int)$_GET['eleccion_id'] : 0;

if ($seccion_id <= 0) {
    echo json_encode([]);
    exit;
}

// ¿cpc tiene eleccion_id?
$hasEleccionCol = (bool)$pdo->query("
    SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE()
      AND TABLE_NAME   = 'circuito_partido_cargo'
      AND COLUMN_NAME  = 'eleccion_id'
")->fetchColumn();

try {
    if ($cargo_id > 0) {
        // Municipio SÍ aparece si:
        // existe circuito c del municipio y existe partido p tal que
        // NO hay cpc(c, cargo_id[, eleccion_id], p, activo=1)
        $sql = "
            SELECT DISTINCT mu.id, mu.nombre
            FROM municipio mu
            JOIN localidad  l  ON l.municipio_id = mu.id
            JOIN circuito   c  ON c.localidad_id = l.id
            WHERE mu.seccion_id = :sec
              AND EXISTS (
                    SELECT 1
                    FROM partido p
                    WHERE NOT EXISTS (
                        SELECT 1
                        FROM circuito_partido_cargo cpc
                        WHERE cpc.circuito_id = c.id
                          AND cpc.cargo_id    = :cargo
                          " . ($hasEleccionCol && $eleccion_id > 0 ? "AND cpc.eleccion_id = :elec" : "") . "
                          AND cpc.partido_id  = p.id
                          AND cpc.activo      = 1
                    )
              )
            ORDER BY mu.nombre
        ";
        $params = [':sec' => $seccion_id, ':cargo' => $cargo_id];
        if ($hasEleccionCol && $eleccion_id > 0) $params[':elec'] = $eleccion_id;

        $stmt = $pdo->prepare($sql);
        $stmt->execute($params);
        echo json_encode($stmt->fetchAll(PDO::FETCH_ASSOC) ?: []);
    } else {
        // Sin cargo seleccionado: devolver todos los municipios de la sección
        $stmt = $pdo->prepare("SELECT id, nombre FROM municipio WHERE seccion_id = :sec ORDER BY nombre");
        $stmt->execute([':sec' => $seccion_id]);
        echo json_encode($stmt->fetchAll(PDO::FETCH_ASSOC) ?: []);
    }
} catch (Throwable $e) {
    http_response_code(500);
    echo json_encode(['error' => true, 'msg' => 'municipios.php error']);
}
