<?php
require_once 'db_pdo.php';
header('Content-Type: application/json; charset=utf-8');

$eleccion_id = (int)($_GET['eleccion_id'] ?? 1);
$cargo_id    = (int)($_GET['cargo_id'] ?? 1);
$seccion_id  = (int)($_GET['seccion_id'] ?? 0);
$municipio_id = (int)($_GET['municipio_id'] ?? 0);
$partido_id  = (int)($_GET['partido_id'] ?? 0);

if ($partido_id <= 0) {
  http_response_code(400);
  echo json_encode(['error' => 'partido_id requerido']);
  exit;
}

$where = " rpm.eleccion_id=:e AND rpm.cargo_id=:c AND rpm.partido_id=:p ";
$bind  = [':e' => $eleccion_id, ':c' => $cargo_id, ':p' => $partido_id];
if ($seccion_id > 0) {
  $where .= " AND s.id = :s ";
  $bind[':s'] = $seccion_id;
}
if ($municipio_id > 0) {
  $where .= " AND mu.id = :m ";
  $bind[':m'] = $municipio_id;
}

/* Por circuito */
$sqlCircuito = "
SELECT c.id, c.nombre AS circuito, SUM(rpm.votos) AS votos
FROM resultado_partido_mesa rpm
JOIN mesa m            ON m.id = rpm.mesa_id
JOIN establecimiento e ON e.id = m.establecimiento_id
JOIN circuito c        ON c.id = e.circuito_id
JOIN localidad l       ON l.id = c.localidad_id
JOIN municipio mu      ON mu.id = l.municipio_id
JOIN seccion s         ON s.id = mu.seccion_id
WHERE $where
GROUP BY c.id, c.nombre
ORDER BY votos DESC, c.nombre ASC
";
$stmt = $pdo->prepare($sqlCircuito);
$stmt->execute($bind);
$circuitos = $stmt->fetchAll();

/* Por mesa (limito a 500 para no explotar modal) */
$sqlMesa = "
SELECT m.id, m.numero AS mesa, e.nombre AS establecimiento, SUM(rpm.votos) AS votos
FROM resultado_partido_mesa rpm
JOIN mesa m            ON m.id = rpm.mesa_id
JOIN establecimiento e ON e.id = m.establecimiento_id
JOIN circuito c        ON c.id = e.circuito_id
JOIN localidad l       ON l.id = c.localidad_id
JOIN municipio mu      ON mu.id = l.municipio_id
JOIN seccion s         ON s.id = mu.seccion_id
WHERE $where
GROUP BY m.id, m.numero, e.nombre
ORDER BY votos DESC, m.numero ASC
LIMIT 500
";
$stmt = $pdo->prepare($sqlMesa);
$stmt->execute($bind);
$mesas = $stmt->fetchAll();

echo json_encode(['circuitos' => $circuitos, 'mesas' => $mesas], JSON_UNESCAPED_UNICODE);
