<?php
ini_set('display_errors','1');
ini_set('display_startup_errors','1');
error_reporting(E_ALL);

require_once 'db_pdo.php';
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }

try {
    $mesa_num           = isset($_GET['mesa']) ? trim($_GET['mesa']) : '';
    $eleccion_id        = isset($_GET['eleccion_id'])  ? (int)$_GET['eleccion_id']  : 1;
    $cargo_id           = isset($_GET['cargo_id'])     ? (int)$_GET['cargo_id']     : 1;
    $seccion_id         = isset($_GET['seccion_id'])   ? (int)$_GET['seccion_id']   : 0;
    $municipio_id       = isset($_GET['municipio_id']) ? (int)$_GET['municipio_id'] : 0;
    $establecimiento_id = isset($_GET['establecimiento_id']) ? (int)$_GET['establecimiento_id'] : 0;

    // Combos UI
    $elecciones = $pdo->query("SELECT id, nombre, fecha FROM eleccion ORDER BY fecha DESC")->fetchAll(PDO::FETCH_ASSOC);
    $cargos     = $pdo->query("SELECT id, nombre FROM cargo ORDER BY id")->fetchAll(PDO::FETCH_ASSOC);
    $secciones  = $pdo->query("SELECT id, nombre FROM seccion ORDER BY nombre")->fetchAll(PDO::FETCH_ASSOC);

    $coincidencias = [];
    $mesa_elegida  = null;
    $res_partidos  = [];
    $res_resumen   = null;

    // Chequeos mínimos
    foreach (['mesa','establecimiento','circuito','localidad','municipio','seccion'] as $t) {
        $pdo->query("SELECT 1 FROM `$t` LIMIT 1");
    }

    if ($mesa_num !== '') {
        // 🔎 Traemos también c.numero y c.nombre
        $sql = "
            SELECT 
                m.id                AS mesa_id,
                m.numero            AS mesa_numero,
                m.votantes          AS padron_mesa,
                e.id                AS establecimiento_id,
                e.nombre            AS establecimiento,
                mu.id               AS municipio_id,
                mu.nombre           AS municipio,
                s.id                AS seccion_id,
                s.nombre            AS seccion,
                c.id                AS circuito_id,
                c.numero            AS circuito_numero,
                c.nombre            AS circuito_nombre
            FROM mesa m
            JOIN establecimiento e ON e.id = m.establecimiento_id
            JOIN circuito c        ON c.id = e.circuito_id
            JOIN localidad l       ON l.id = c.localidad_id
            JOIN municipio mu      ON mu.id = l.municipio_id
            JOIN seccion s         ON s.id = mu.seccion_id
            WHERE m.numero = :mesa
        ";

        $params = [':mesa' => $mesa_num];
        if ($seccion_id > 0)         { $sql .= " AND s.id = :seccion_id";         $params[':seccion_id'] = $seccion_id; }
        if ($municipio_id > 0)       { $sql .= " AND mu.id = :municipio_id";      $params[':municipio_id'] = $municipio_id; }
        if ($establecimiento_id > 0) { $sql .= " AND e.id = :establecimiento_id"; $params[':establecimiento_id'] = $establecimiento_id; }

        $sql .= " ORDER BY s.nombre, mu.nombre, e.nombre, m.id";

        $st = $pdo->prepare($sql);
        $st->execute($params);
        $coincidencias = $st->fetchAll(PDO::FETCH_ASSOC);

        if (count($coincidencias) === 1) {
            $mesa_elegida = $coincidencias[0];

            // Verifico tablas de resultados
            foreach (['partido','resultado_partido_mesa','resumen_mesa'] as $t) {
                $pdo->query("SELECT 1 FROM `$t` LIMIT 1");
            }

            // Votos por partido (mesa puntual)
            $st = $pdo->prepare("
                SELECT p.id, p.nombre, COALESCE(rpm.votos,0) AS votos
                FROM resultado_partido_mesa rpm
                JOIN partido p ON p.id = rpm.partido_id
                WHERE rpm.mesa_id = :mesa_id
                  AND rpm.eleccion_id = :eleccion_id
                  AND rpm.cargo_id = :cargo_id
                ORDER BY votos DESC, p.nombre ASC
            ");
            $st->execute([
                ':mesa_id'     => $mesa_elegida['mesa_id'],
                ':eleccion_id' => $eleccion_id,
                ':cargo_id'    => $cargo_id,
            ]);
            $res_partidos = $st->fetchAll(PDO::FETCH_ASSOC);

            // Resumen de la mesa
            $st = $pdo->prepare("
                SELECT
                  COALESCE(rm.votos_blanco,0)      AS blancos,
                  COALESCE(rm.votos_nulos,0)       AS nulos,
                  COALESCE(rm.votos_recurridos,0)  AS recurridos,
                  COALESCE(rm.votos_impugnados,0)  AS impugnados,
                  COALESCE(rm.votos_comando,0)     AS comando,
                  COALESCE(rm.electores_votaron,0) AS votaron,
                  COALESCE(rm.sobres_en_urna,0)    AS sobres
                FROM resumen_mesa rm
                WHERE rm.mesa_id = :mesa_id
                  AND rm.eleccion_id = :eleccion_id
                  AND rm.cargo_id = :cargo_id
                LIMIT 1
            ");
            $st->execute([
                ':mesa_id'     => $mesa_elegida['mesa_id'],
                ':eleccion_id' => $eleccion_id,
                ':cargo_id'    => $cargo_id,
            ]);
            $res_resumen = $st->fetch(PDO::FETCH_ASSOC) ?: [
                'blancos'=>0,'nulos'=>0,'recurridos'=>0,'impugnados'=>0,'comando'=>0,'votaron'=>0,'sobres'=>0
            ];
        }
    }
} catch (Throwable $e) {
    http_response_code(500);
    echo "<pre style='color:#fca5a5;background:#1f2937;padding:16px;border-radius:8px'>";
    echo "ERROR: ".$e->getMessage()."\n\n";
    echo $e->getTraceAsString();
    echo "</pre>";
    exit;
}
?>
<!doctype html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <title>Buscar por Mesa</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-slate-950 text-slate-100">
<div class="max-w-5xl mx-auto p-4 space-y-6">
  <h1 class="text-xl font-bold">🔎 Buscar datos por Mesa</h1>

  <!-- Form -->
  <form class="grid md:grid-cols-5 gap-3 bg-slate-800/80 p-4 rounded-xl" method="get">
    <label class="text-sm md:col-span-2">
      <span class="block mb-1 text-slate-400">Mesa (número)</span>
      <input type="text" name="mesa" value="<?= h($mesa_num) ?>" class="w-full bg-slate-900 rounded p-2" placeholder="Ej: 1234" required>
    </label>
    <label class="text-sm">
      <span class="block mb-1 text-slate-400">Elección</span>
      <select name="eleccion_id" class="w-full bg-slate-900 rounded p-2">
        <?php foreach ($elecciones as $e): ?>
          <option value="<?= (int)$e['id'] ?>" <?= ((int)$e['id']===(int)$eleccion_id)?'selected':'' ?>>
            <?= h($e['nombre']).' ('.$e['fecha'].')' ?>
          </option>
        <?php endforeach; ?>
      </select>
    </label>
    <label class="text-sm">
      <span class="block mb-1 text-slate-400">Cargo</span>
      <select name="cargo_id" class="w-full bg-slate-900 rounded p-2">
        <?php foreach ($cargos as $c): ?>
          <option value="<?= (int)$c['id'] ?>" <?= ((int)$c['id']===(int)$cargo_id)?'selected':'' ?>>
            <?= h($c['nombre']) ?>
          </option>
        <?php endforeach; ?>
      </select>
    </label>
    <div class="md:col-span-1 flex items-end">
      <button class="w-full bg-emerald-600 hover:bg-emerald-500 rounded p-2 font-semibold">Buscar</button>
    </div>

    <!-- Filtros opcionales -->
    <div class="md:col-span-5 grid md:grid-cols-3 gap-3">
      <label class="text-sm">
        <span class="block mb-1 text-slate-400">Departamento (Sección) [opcional]</span>
        <select name="seccion_id" class="w-full bg-slate-900 rounded p-2">
          <option value="0">Cualquiera</option>
          <?php foreach ($secciones as $s): ?>
            <option value="<?= (int)$s['id'] ?>" <?= ((int)$s['id']===(int)$seccion_id)?'selected':'' ?>>
              <?= h($s['nombre']) ?>
            </option>
          <?php endforeach; ?>
        </select>
      </label>
      <label class="text-sm">
        <span class="block mb-1 text-slate-400">Municipio [opcional]</span>
        <input type="number" name="municipio_id" value="<?= (int)$municipio_id ?>" class="w-full bg-slate-900 rounded p-2" placeholder="ID de municipio">
      </label>
      <label class="text-sm">
        <span class="block mb-1 text-slate-400">Establecimiento [opcional]</span>
        <input type="number" name="establecimiento_id" value="<?= (int)$establecimiento_id ?>" class="w-full bg-slate-900 rounded p-2" placeholder="ID de establecimiento">
      </label>
    </div>
  </form>

  <?php if ($mesa_num !== ''): ?>
    <?php if (empty($coincidencias)): ?>
      <div class="bg-amber-500/10 border border-amber-500/30 text-amber-200 p-3 rounded">
        No encontré mesas con número <strong><?= h($mesa_num) ?></strong> con los filtros actuales.
      </div>

    <?php elseif (count($coincidencias) > 1 && !$mesa_elegida): ?>
      <div class="bg-slate-800/60 p-3 rounded">
        <div class="font-semibold mb-2">Hay varias mesas con número <?= h($mesa_num) ?>. Refiná o hacé clic en una:</div>
        <div class="overflow-x-auto">
          <table class="min-w-full text-sm">
            <thead class="text-left text-slate-400">
              <tr>
                <th class="py-1">Mesa</th>
                <th class="py-1">Circuito</th>
                <th class="py-1">Establecimiento</th>
                <th class="py-1">Municipio</th>
                <th class="py-1">Sección</th>
                <th class="py-1">Acción</th>
              </tr>
            </thead>
            <tbody>
            <?php foreach ($coincidencias as $m):
              $qs = [
                'mesa' => $mesa_num,
                'eleccion_id' => $eleccion_id,
                'cargo_id' => $cargo_id,
                'seccion_id' => $m['seccion_id'],
                'municipio_id' => $m['municipio_id'],
                'establecimiento_id' => $m['establecimiento_id'],
              ];
              $href = 'buscar_mesa.php?'.http_build_query($qs);
            ?>
              <tr class="border-t border-slate-800">
                <td class="py-1 pr-3">#<?= (int)$m['mesa_numero'] ?> (ID <?= (int)$m['mesa_id'] ?>)</td>
                <td class="py-1 pr-3"><?= h($m['circuito_numero']) ?> (<?= h($m['circuito_nombre']) ?>)</td>
                <td class="py-1 pr-3"><?= h($m['establecimiento']) ?></td>
                <td class="py-1 pr-3"><?= h($m['municipio']) ?></td>
                <td class="py-1 pr-3"><?= h($m['seccion']) ?></td>
                <td class="py-1"><a class="px-2 py-1 rounded bg-emerald-600/20 hover:bg-emerald-600/30" href="<?= h($href) ?>">Ver</a></td>
              </tr>
            <?php endforeach; ?>
            </tbody>
          </table>
        </div>
      </div>

    <?php else: ?>
      <section class="space-y-4">
        <div class="bg-slate-800/60 rounded p-4">
          <div class="text-sm text-slate-400 mb-1">Resumen de mesa</div>
          <div class="grid md:grid-cols-3 gap-2 text-sm">
            <div><span class="text-slate-400">Mesa:</span> #<?= (int)$mesa_elegida['mesa_numero'] ?> (ID <?= (int)$mesa_elegida['mesa_id'] ?>)</div>
            <div><span class="text-slate-400">Establecimiento:</span> <?= h($mesa_elegida['establecimiento']) ?></div>
            <div><span class="text-slate-400">Municipio:</span> <?= h($mesa_elegida['municipio']) ?></div>
            <div><span class="text-slate-400">Sección:</span> <?= h($mesa_elegida['seccion']) ?></div>
            <!-- ✅ Ahora mostramos circuito.numero (y nombre) en vez de ID -->
            <div><span class="text-slate-400">Circuito:</span> <?= h($mesa_elegida['circuito_numero']) ?> (<?= h($mesa_elegida['circuito_nombre']) ?>)</div>
            <div><span class="text-slate-400">Padrón mesa:</span> <?= number_format((int)$mesa_elegida['padron_mesa'],0,',','.') ?></div>
          </div>
        </div>

        <div class="grid md:grid-cols-3 gap-4">
          <div class="bg-slate-800/60 rounded p-4">
            <div class="text-sm text-slate-400 mb-1">Votaron</div>
            <div class="text-2xl font-semibold"><?= number_format((int)$res_resumen['votaron'],0,',','.') ?></div>
          </div>
          <div class="bg-slate-800/60 rounded p-4">
            <div class="text-sm text-slate-400 mb-1">Sobres</div>
            <div class="text-2xl font-semibold"><?= number_format((int)$res_resumen['sobres'],0,',','.') ?></div>
          </div>
          <div class="bg-slate-800/60 rounded p-4">
            <div class="text-sm text-slate-400 mb-1">Blancos / Nulos+Obs</div>
            <div class="text-2xl font-semibold">
              <?= number_format((int)$res_resumen['blancos'],0,',','.') ?>
              <span class="text-sm text-slate-400"> / </span>
              <?= number_format(((int)$res_resumen['nulos']+(int)$res_resumen['recurridos']+(int)$res_resumen['impugnados']),0,',','.') ?>
            </div>
          </div>
        </div>

        <div class="bg-slate-800/60 rounded p-4">
          <div class="flex items-center justify-between mb-2">
            <h3 class="font-semibold">Votos por partido (mesa #<?= (int)$mesa_elegida['mesa_numero'] ?>)</h3>
            <div class="text-sm text-slate-400">Elección <?= (int)$eleccion_id ?> · Cargo <?= (int)$cargo_id ?></div>
          </div>
          <div class="overflow-x-auto">
            <table class="min-w-full text-sm">
              <thead class="text-left text-slate-400">
                <tr>
                  <th class="py-1">#</th>
                  <th class="py-1">Partido</th>
                  <th class="py-1">Votos</th>
                </tr>
              </thead>
              <tbody>
                <?php if (empty($res_partidos)): ?>
                  <tr class="border-t border-slate-800"><td colspan="3" class="py-2 text-slate-300">Sin carga de votos para esta mesa/cargo/elección.</td></tr>
                <?php else: $i=1; foreach ($res_partidos as $r): ?>
                  <tr class="border-t border-slate-800">
                    <td class="py-1 pr-3"><?= $i++ ?></td>
                    <td class="py-1 pr-3"><?= h($r['nombre']) ?></td>
                    <td class="py-1"><?= number_format((int)$r['votos'],0,',','.') ?></td>
                  </tr>
                <?php endforeach; endif; ?>
              </tbody>
            </table>
          </div>
        </div>
      </section>
    <?php endif; ?>
  <?php endif; ?>
</div>
</body>
</html>
