<?php
require_once 'db_pdo.php';

$eleccion_id = (int)($_GET['eleccion_id'] ?? 1);
$cargo_id    = (int)($_GET['cargo_id'] ?? 1);

// Trae el partido ganador por departamento
$sql = "
SELECT 
  s.nombre AS nombre,
  p.nombre AS partido,
  ROUND((SUM(rpm.votos_partido) / SUM(rpm.votos_validos)) * 100, 1) AS pct
FROM resultado_partido_mesa rpm
JOIN mesa m ON m.id = rpm.mesa_id
JOIN establecimiento e ON e.id = m.establecimiento_id
JOIN circuito c ON c.id = e.circuito_id
JOIN localidad l ON l.id = c.localidad_id
JOIN municipio mu ON mu.id = l.municipio_id
JOIN seccion s ON s.id = mu.seccion_id
JOIN partido p ON p.id = rpm.partido_id
WHERE rpm.eleccion_id = :e AND rpm.cargo_id = :c
GROUP BY s.id, p.id
HAVING pct = (
  SELECT MAX((SUM(votos_partido)/SUM(votos_validos))*100)
  FROM resultado_partido_mesa rpm2
  JOIN mesa m2 ON m2.id = rpm2.mesa_id
  JOIN establecimiento e2 ON e2.id = m2.establecimiento_id
  JOIN circuito c2 ON c2.id = e2.circuito_id
  JOIN localidad l2 ON l2.id = c2.localidad_id
  JOIN municipio mu2 ON mu2.id = l2.municipio_id
  JOIN seccion s2 ON s2.id = mu2.seccion_id
  WHERE rpm2.eleccion_id = :e AND rpm2.cargo_id = :c AND s2.id = s.id
)
ORDER BY pct DESC
LIMIT 5
";

$stmt = $pdo->prepare($sql);
$stmt->execute([':e' => $eleccion_id, ':c' => $cargo_id]);
echo json_encode($stmt->fetchAll(PDO::FETCH_ASSOC));
