<?php
require_once 'db_pdo.php';
header('Content-Type: application/json; charset=utf-8');

$e = (int)($_GET['eleccion_id'] ?? 1);
$c = (int)($_GET['cargo_id'] ?? 1);
$s = (int)($_GET['seccion_id'] ?? 0);
$m = (int)($_GET['municipio_id'] ?? 0);

$where = " rm.eleccion_id=:e AND rm.cargo_id=:c ";
$bind = [':e' => $e, ':c' => $c];
if ($s > 0) {
    $where .= " AND s.id=:s ";
    $bind[':s'] = $s;
}
if ($m > 0) {
    $where .= " AND mu.id=:m ";
    $bind[':m'] = $m;
}

$sql = "SELECT
        COALESCE(SUM(rm.votos_blanco),0)      AS blancos,
        COALESCE(SUM(rm.votos_nulos),0)       AS nulos,
        COALESCE(SUM(rm.votos_recurridos),0)  AS recurridos,
        COALESCE(SUM(rm.votos_impugnados),0)  AS impugnados,
        COALESCE(SUM(rm.electores_votaron),0) AS votaron,
        COALESCE(SUM(rm.sobres_en_urna),0)    AS sobres
      FROM resumen_mesa rm
      JOIN mesa m            ON m.id = rm.mesa_id
      JOIN establecimiento e ON e.id = m.establecimiento_id
      JOIN circuito c        ON c.id = e.circuito_id
      JOIN localidad l       ON l.id = c.localidad_id
      JOIN municipio mu      ON mu.id = l.municipio_id
      JOIN seccion s         ON s.id = mu.seccion_id
      WHERE $where";
$stmt = $pdo->prepare($sql);
$stmt->execute($bind);
echo json_encode($stmt->fetch() ?: [], JSON_UNESCAPED_UNICODE);
