<?php
require_once 'db_pdo.php';
header('Content-Type: application/json; charset=utf-8');

$e = (int)($_GET['eleccion_id'] ?? 1);
$c = (int)($_GET['cargo_id'] ?? 1);
$s = (int)($_GET['seccion_id'] ?? 0);
$m = (int)($_GET['municipio_id'] ?? 0);

$where = " rpm.eleccion_id=:e AND rpm.cargo_id=:c ";
$bind = [':e' => $e, ':c' => $c];
if ($s > 0) {
    $where .= " AND s.id=:s ";
    $bind[':s'] = $s;
}
if ($m > 0) {
    $where .= " AND mu.id=:m ";
    $bind[':m'] = $m;
}

$sql = "SELECT p.id, p.nombre, SUM(rpm.votos) AS votos
      FROM resultado_partido_mesa rpm
      JOIN partido p         ON p.id = rpm.partido_id
      JOIN mesa m            ON m.id = rpm.mesa_id
      JOIN establecimiento e ON e.id = m.establecimiento_id
      JOIN circuito c        ON c.id = e.circuito_id
      JOIN localidad l       ON l.id = c.localidad_id
      JOIN municipio mu      ON mu.id = l.municipio_id
      JOIN seccion s         ON s.id = mu.seccion_id
      WHERE $where
      GROUP BY p.id, p.nombre
      ORDER BY votos DESC, p.nombre ASC";
$stmt = $pdo->prepare($sql);
$stmt->execute($bind);
echo json_encode($stmt->fetchAll(), JSON_UNESCAPED_UNICODE);
