<?php
require_once 'db_pdo.php';

header('Content-Type: application/json; charset=utf-8');

$eleccion_id  = isset($_GET['eleccion_id'])  ? (int)$_GET['eleccion_id']  : 1;
$cargo_id     = isset($_GET['cargo_id'])     ? (int)$_GET['cargo_id']     : 1;
$seccion_id   = isset($_GET['seccion_id'])   ? (int)$_GET['seccion_id']   : 0; // (opcional) para filtrar 1 solo dpto en la tarjeta
$municipio_id = isset($_GET['municipio_id']) ? (int)$_GET['municipio_id'] : 0;
$partido_id   = isset($_GET['partido_id'])   ? (int)$_GET['partido_id']   : 0;

$whereGeo = '';
$params = [
    ':eleccion_id' => $eleccion_id,
    ':cargo_id'    => $cargo_id,
];

if ($seccion_id > 0) {
    $whereGeo .= " AND s.id = :seccion_id ";
    $params[':seccion_id'] = $seccion_id;
}
if ($municipio_id > 0) {
    $whereGeo .= " AND mu.id = :municipio_id ";
    $params[':municipio_id'] = $municipio_id;
}

/*
  1) total_validos por sección = suma de votos de TODOS los partidos (sin blancos/nulos)
  2) votos por partido y sección
  3) si viene partido_id => pct de ese partido; si no viene => pct del GANADOR
*/

$sql = "
WITH votos_por_partido AS (
  SELECT
    s.id   AS seccion_id,
    s.nombre AS seccion,
    p.id   AS partido_id,
    p.nombre AS partido,
    COALESCE(SUM(rpm.votos),0) AS votos
  FROM resultado_partido_mesa rpm
  JOIN partido p         ON p.id = rpm.partido_id
  JOIN mesa m            ON m.id = rpm.mesa_id
  JOIN establecimiento e ON e.id = m.establecimiento_id
  JOIN circuito c        ON c.id = e.circuito_id
  JOIN localidad l       ON l.id = c.localidad_id
  JOIN municipio mu      ON mu.id = l.municipio_id
  JOIN seccion s         ON s.id = mu.seccion_id
  WHERE rpm.eleccion_id = :eleccion_id
    AND rpm.cargo_id    = :cargo_id
    $whereGeo
  GROUP BY s.id, s.nombre, p.id, p.nombre
),
validos_por_seccion AS (
  SELECT seccion_id, seccion, SUM(votos) AS total_validos
  FROM votos_por_partido
  GROUP BY seccion_id, seccion
)
";

if ($partido_id > 0) {
    // % del partido pedido sobre válidos de la sección
    $sql .= "
  SELECT
    vpp.seccion_id,
    vpp.seccion,
    vpp.partido AS partido_nombre,
    vpp.votos,
    vps.total_validos,
    CASE WHEN vps.total_validos > 0 THEN (vpp.votos * 100.0 / vps.total_validos) ELSE 0 END AS pct
  FROM votos_por_partido vpp
  JOIN validos_por_seccion vps ON vps.seccion_id = vpp.seccion_id
  WHERE vpp.partido_id = :partido_id
  ORDER BY vpp.seccion ASC
  ";
    $params[':partido_id'] = $partido_id;
} else {
    // ganador por sección + % del ganador sobre válidos de la sección
    $sql .= "
  , ganador_por_seccion AS (
    SELECT t.*
    FROM (
      SELECT
        vpp.seccion_id,
        vpp.seccion,
        vpp.partido_id,
        vpp.partido AS partido_nombre,
        vpp.votos,
        ROW_NUMBER() OVER (PARTITION BY vpp.seccion_id ORDER BY vpp.votos DESC, vpp.partido ASC) AS rk
      FROM votos_por_partido vpp
    ) t
    WHERE t.rk = 1
  )
  SELECT
    g.seccion_id,
    g.seccion,
    g.partido_nombre,
    g.votos,
    vps.total_validos,
    CASE WHEN vps.total_validos > 0 THEN (g.votos * 100.0 / vps.total_validos) ELSE 0 END AS pct
  FROM ganador_por_seccion g
  JOIN validos_por_seccion vps ON vps.seccion_id = g.seccion_id
  ORDER BY g.seccion ASC
  ";
}

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

echo json_encode($rows, JSON_UNESCAPED_UNICODE);
